/*
 * Decompiled with CFR 0.152.
 */
package xaero.map.controls;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.settings.KeyBinding;
import net.minecraft.client.util.InputMappings;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraftforge.client.settings.IKeyConflictContext;
import net.minecraftforge.client.settings.KeyConflictContext;
import org.lwjgl.glfw.GLFW;
import xaero.map.MapProcessor;
import xaero.map.WorldMap;
import xaero.map.WorldMapSession;
import xaero.map.controls.ControlsRegister;
import xaero.map.controls.KeyEvent;
import xaero.map.gui.GuiMap;
import xaero.map.gui.GuiWorldMapSettings;

public class ControlsHandler {
    private MapProcessor mapProcessor;
    private ArrayList<KeyEvent> keyEvents = new ArrayList();
    private ArrayList<KeyEvent> oldKeyEvents = new ArrayList();

    public ControlsHandler(MapProcessor mapProcessor) {
        this.mapProcessor = mapProcessor;
    }

    private boolean eventExists(KeyBinding kb) {
        for (KeyEvent o : this.keyEvents) {
            if (o.getKb() != kb) continue;
            return true;
        }
        return this.oldEventExists(kb);
    }

    private boolean oldEventExists(KeyBinding kb) {
        for (KeyEvent o : this.oldKeyEvents) {
            if (o.getKb() != kb) continue;
            return true;
        }
        return false;
    }

    public static void setKeyState(KeyBinding kb, boolean pressed) {
        if (kb.func_151470_d() != pressed) {
            KeyBinding.func_197980_a((InputMappings.Input)kb.getKey(), (boolean)pressed);
        }
    }

    public static boolean isDown(KeyBinding kb) {
        if (kb.getKey().func_197937_c() == -1) {
            return false;
        }
        if (kb.getKey().func_197938_b() == InputMappings.Type.MOUSE) {
            return GLFW.glfwGetMouseButton((long)Minecraft.func_71410_x().func_228018_at_().func_198092_i(), (int)kb.getKey().func_197937_c()) == 1;
        }
        if (kb.getKey().func_197938_b() == InputMappings.Type.KEYSYM) {
            return InputMappings.func_216506_a((long)Minecraft.func_71410_x().func_228018_at_().func_198092_i(), (int)kb.getKey().func_197937_c());
        }
        return false;
    }

    public static boolean isKeyRepeat(KeyBinding kb) {
        return kb != ControlsRegister.keyOpenMap && kb != ControlsRegister.keyOpenSettings;
    }

    public void keyDown(KeyBinding kb, boolean tickEnd, boolean isRepeat) {
        Minecraft mc = Minecraft.func_71410_x();
        if (!tickEnd) {
            if (kb == ControlsRegister.keyOpenMap) {
                mc.func_147108_a((Screen)new GuiMap(null, null, this.mapProcessor, (PlayerEntity)mc.field_71439_g));
            } else if (kb == ControlsRegister.keyOpenSettings) {
                mc.func_147108_a((Screen)new GuiWorldMapSettings());
            } else if (kb == ControlsRegister.keyQuickConfirm) {
                WorldMapSession worldmapSession = WorldMapSession.getCurrentSession();
                MapProcessor mapProcessor = worldmapSession.getMapProcessor();
                mapProcessor.quickConfirmMultiworld();
            }
        }
    }

    public void keyUp(KeyBinding kb, boolean tickEnd) {
        if (!tickEnd) {
            // empty if block
        }
    }

    public void handleKeyEvents() {
        KeyEvent ke;
        int i;
        Minecraft mc = Minecraft.func_71410_x();
        this.onKeyInput(mc);
        for (i = 0; i < this.keyEvents.size(); ++i) {
            ke = this.keyEvents.get(i);
            if (mc.field_71462_r == null) {
                this.keyDown(ke.getKb(), ke.isTickEnd(), ke.isRepeat());
            }
            if (!ke.isRepeat()) {
                if (!this.oldEventExists(ke.getKb())) {
                    this.oldKeyEvents.add(ke);
                }
                this.keyEvents.remove(i);
                --i;
                continue;
            }
            if (ControlsHandler.isDown(ke.getKb())) continue;
            this.keyUp(ke.getKb(), ke.isTickEnd());
            this.keyEvents.remove(i);
            --i;
        }
        for (i = 0; i < this.oldKeyEvents.size(); ++i) {
            ke = this.oldKeyEvents.get(i);
            if (ControlsHandler.isDown(ke.getKb())) continue;
            this.keyUp(ke.getKb(), ke.isTickEnd());
            this.oldKeyEvents.remove(i);
            --i;
        }
    }

    public void onKeyInput(Minecraft mc) {
        List<KeyBinding> kbs = WorldMap.controlsRegister.keybindings;
        for (int i = 0; i < kbs.size(); ++i) {
            KeyBinding kb = kbs.get(i);
            try {
                boolean pressed;
                boolean bl = pressed = kb.func_151468_f() && kb.getKeyModifier().isActive((IKeyConflictContext)KeyConflictContext.IN_GAME);
                while (kb.func_151468_f()) {
                }
                if (mc.field_71462_r != null || this.eventExists(kb) || !pressed) continue;
                this.keyEvents.add(new KeyEvent(kb, false, ControlsHandler.isKeyRepeat(kb), true));
                continue;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }
}

